﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helper;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Management;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for Inventory.xaml
    /// </summary>
    public partial class Inventory : Page
    {
        #region Private Variables
        private List<Products> ProductList { get; set; }
        private static List<Products> BarcodeProducts { get; set; }
        private const int PageSize = 15;
        private const int InitialPage = 1;
        private int NoOfPages { get; set; }
        private int CurrentPage { get; set; }
        #endregion

        #region Constructor
        public Inventory()
        {
            InitializeComponent();
            ProductList = AppSession.ProductsList;
            LoadInventory();
            //LoadPager();
            BarcodeProducts = new List<Products>();

        }
        #endregion

        #region Private Methods

        /// <summary>
        /// LoadPager Method will provide the Initial setting for the Pager Control
        /// </summary>
        //private void LoadPager()
        //{
        //    txtPage.Text = InitialPage.ToString();
        //    CurrentPage = InitialPage;
        //    NoOfPages = Convert.ToInt32(Math.Ceiling(((decimal)ProductList.Count / (decimal)PageSize)));
        //    btnFirst.IsEnabled = btnPrevious.IsEnabled = false;
        //    LoadPagerInfo();
        //}

        /// <summary>
        /// This Method loads the Inventory Grid from the data retrieved from Database.
        /// </summary>
        private void LoadInventory()
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
            {
                Dispatcher.BeginInvoke((Action)(() =>
                {
            gvInventory.ItemsSource = ProductList;
                }));
            });
        }

        private void LoadPagerInfo()
        {
            int startingNumber = 0, endingNumber = 0;
            startingNumber = CurrentPage != 0 ? (CurrentPage - 1) * PageSize + 1 : 1;
            endingNumber = (CurrentPage * PageSize) > ProductList.Count ? ProductList.Count : (CurrentPage * PageSize);
            lblInfoDisplay.Text = string.Format("Displaying {0} - {1} of {2} Products", startingNumber, endingNumber, ProductList.Count);
        }

        #endregion

        #region Page Events
        /// <summary>
        /// Event Handler for Page Navigation, when user enters a Page Number and clicks Enter.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        //private void txtPage_KeyDown(object sender, KeyEventArgs e)
        //{
        //    if (e.Key == Key.Return)
        //    {
        //        Keyboard.ClearFocus();
        //        SetupParameters();
        //    }
        //}
        /// <summary>
        /// Next Button Click Handler
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        //private void btnNext_Click(object sender, RoutedEventArgs e)
        //{
        //    NavigateToPage(CurrentPage + 1);
        //}
        /// <summary>
        /// Last Button Click Handler
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        //private void btnLast_Click(object sender, RoutedEventArgs e)
        //{
        //    NavigateToPage(NoOfPages);
        //}
        /// <summary>
        /// First Button Click Handler
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        //private void btnFirst_Click(object sender, RoutedEventArgs e)
        //{
        //    NavigateToPage(InitialPage);
        //}
        /// <summary>
        /// Previous Button Event Handler
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        //private void btnPreviousClick(object sender, RoutedEventArgs e)
        //{
        //    NavigateToPage(CurrentPage - 1);
        //}
        /// <summary>
        /// Page Number Textbox Lost focus Event Handler.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        //private void txtPage_LostFocus(object sender, RoutedEventArgs e)
        //{
        //    SetupParameters();
        //}

        /// <summary>
        /// NavigateToPage will validate the requested Page Number and binds the grid with appropriate response.
        /// </summary>
        /// <param name="PageNo">An Integer Page Number</param>
        //void NavigateToPage(int PageNo)
        //{
        //    BarcodeProducts.Clear();
        //    PageNo = PageNo <= 0 ? 1 : PageNo;
        //    //If Navigated to Last Page, Disable Next , Last Buttons
        //    if (PageNo >= NoOfPages)
        //    {
        //        CurrentPage = PageNo = NoOfPages;
        //        btnNext.IsEnabled = false;
        //        btnLast.IsEnabled = false;
        //    }
        //    else
        //    {
        //        btnNext.IsEnabled = true;
        //        btnLast.IsEnabled = true;
        //    }
        //    //If Navigated to First Page, Disable Previous, First Buttons
        //    if (PageNo == InitialPage)
        //    {
        //        CurrentPage = PageNo = InitialPage;
        //        btnFirst.IsEnabled = false;
        //        btnPrevious.IsEnabled = false;
        //    }
        //    else
        //    {
        //        btnFirst.IsEnabled = true;
        //        btnPrevious.IsEnabled = true;

        //    }
        //    //If Navigated to Pages in middle range, enable all the buttons.
        //    if (PageNo < NoOfPages && PageNo > InitialPage)
        //    {
        //        CurrentPage = PageNo;
        //        btnFirst.IsEnabled = true;
        //        btnPrevious.IsEnabled = true;
        //        btnLast.IsEnabled = true;
        //        btnNext.IsEnabled = true;
        //    }
        //    int ItemsToSkip = PageSize * (PageNo - 1);
        //    gvInventory.ItemsSource = ProductList.Skip(ItemsToSkip).Take(PageSize);
        //    LoadPagerInfo();
        //    txtPage.Text = PageNo.ToString();
        //}

        /// <summary>
        /// SetUpParameters will validate the Page Number requested and alters the request as required.
        /// </summary>
        //private void SetupParameters()
        //{
        //    int parsable;
        //    if (int.TryParse(txtPage.Text, out parsable))
        //    {
        //        NavigateToPage(parsable);
        //    }
        //    else
        //    {
        //        txtPage.Text = InitialPage.ToString();
        //        NavigateToPage(InitialPage);
        //    }
        //}

        private void btnSearch_Click(object sender, RoutedEventArgs e)
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
            {
                Dispatcher.BeginInvoke((Action)(() =>
                {
            if (!txtSearch.Text.Trim().Empty())
            {
                ProductList = (from p in AppSession.ProductsList
                               where (p.ProductName.ToLower().Contains(txtSearch.Text.Trim().ToLower()) ||
                                    p.ProductDescriptions.ToLower().Contains(txtSearch.Text.Trim().ToLower()) ||
                                    p.ProductCode.ToLower().Contains(txtSearch.Text.Trim().ToLower()) ||
                                    p.AdditionalInfo.ToLower().Contains(txtSearch.Text.Trim().ToLower()) ||
                                    p.UnitPrice.ToString().ToLower().Contains(txtSearch.Text.Trim().ToLower()))
                               orderby p.SequenceNo ascending
                               select p).ToList<Products>();

                if (ProductList.Count == 0)
                {
                    lblError.Text = "No Products Found!";
                    btnClear.IsEnabled = false;
                    return;
                }
                else
                {
                    lblError.Text = string.Empty;
                    btnClear.IsEnabled = true;
                }
                        //gvInventory.Columns[0].Visibility = Visibility.Collapsed;
                gvInventory.ItemsSource = ProductList;
                        CurrentPage = 1;
                LoadPagerInfo();

            }
                }));
            });
        }

        private void btnClear_Click(object sender, RoutedEventArgs e)
        {
            ProductList = AppSession.ProductsList;
            //gvInventory.Columns[0].Visibility = Visibility.Visible;
            btnClear.IsEnabled = false;
            txtSearch.Clear();
            LoadInventory();
            //LoadPager();
        }

        #endregion

        private DataGridRow GetParent(DependencyObject dep)
        {
            DependencyObject Obj = null;
            if (dep.GetType() == typeof(DataGridRow))
            {
                Obj = dep as DataGridRow;
            }
            else
            {
                Obj = GetParent(VisualTreeHelper.GetParent(dep));
            }
            return Obj as DataGridRow;
        }

        private void btnExport_Click(object sender, RoutedEventArgs e)
        {
            ExcelExportHelper.Export(gvInventory, "InventoryReport");
        }

        private void btnPrint_Click(object sender, RoutedEventArgs e)
        {
            PrintReportHelper.Print(gvInventory, "Inventory Report");
        }

        private void ScrollViewer_ScrollChanged_1(object sender, ScrollChangedEventArgs e)
        {

        }

        private void btnPrintBarcode_Click(object sender, RoutedEventArgs e)
        {
            //Access BarcodeProducts to have a list of string to be printed.
            int copies = 1;

            Button print = (Button)sender;

            if (bool.Parse(print.Tag.ToString()))
                int.TryParse(txtBarcodeCopy.Text.Empty() ? "1" : txtBarcodeCopy.Text.Trim(), out copies);

            copies = copies <= 0 ? 1 : copies;
            //Access copies variable to access the No. of copies to print - Default it to 1 if nothing/invalid value is given.
            BarcodePrintHelper.PrintBarcode(BarcodeProducts, copies);
        }

        private void chkPrint_Checked(object sender, RoutedEventArgs e)
        {
            CheckBox chk = sender as CheckBox;
            DataGridRow dgr = GetParent(chk);
            Products prod = dgr.DataContext as Products;
            if (BarcodeProducts.Contains(prod))
                BarcodeProducts.Remove(prod);
            else
                BarcodeProducts.Add(prod);
        }
    }
}

